<?php

namespace elanpl\L3;

abstract class ViewModel{
    private $module;
    private $controller;
    private $action;
    public $_L3;
                    
    public function __construct($arg)
    {
        if($arg instanceof Applicstion){
            $this->_L3 = $_L3;
        }
        else{
            global $_L3;
            $this->_L3 = $_L3;
        }

        $match = $this->_L3->findControllerInCallStack();

        $this->controller = $match['controller'];
        $this->module = $match['module'];
        $this->action = $match['action'];
    }

    public function getController(){
        if(!isset($this->controller)){
            throw new \Exception("Controller not found in ViewModel \"".get_class($this)."! Use parent::__construct() in the class constructor or setController method.");
        }
        else
            return $this->controller;
    }

    public function getAction(){
        if(!isset($this->action)){
            throw new \Exception("Action not found in ViewModel \"".get_class($this)."! Use parent::___construct() in the class constructor or setAction method.");
        }
        return $this->action;
    }

    public function getModule(){
        return $this->module;
    }

    public function setController($controller){ 
        return $this->controller = $controller;
    }

    public function setAction($action){ 
        return $this->action = $action;
    }

    public function setModule($module){ 
        return $this->module = $module;
    }

    public function getDTO(){
        //function to be overriden
    }
}