<?php

namespace elanpl\L3;

class ViewEngine{
    protected $viewengines; //registered view engines dictionary

    public function __construct()
    {
        $this->viewengines = array(); 
    }

    public function register($fileExtension, $viewEngine, $config = null){
        if(!class_exists($viewEngine,true)){
            throw new \Exception("Class \"$viewEngine\" not found!");
        }
        if(!isset(class_implements($viewEngine, true)['elanpl\\L3\\IViewEngine'])){
            throw new \Exception("Class \"$viewEngine\" does not implement IViewEngine interface!");
        }

        $vn = new ViewEngineInfo($fileExtension, $viewEngine, $config);

        $this->viewengines[$fileExtension] = $vn;
    }

    public function get($fileExtension){
        if(array_key_exists($fileExtension, $this->viewengines)){
            return $this->viewengines[$fileExtension];
        }
        else{
            return null;
        }
    }

    public function getRegisteredFileExtensions(){
        return array_keys($this->viewengines);
    }

}