<?php

namespace elanpl\L3;

class Request{
    public $path;
    public $method;
    public $accept;
    public $acceptTypes;
    public $acceptLanguage;
    public $userAgent;
    public $headers;
    public $body;
    public function __construct(){
        if(isset($_SERVER['L3_PATH']))
            $this->path = $_SERVER['L3_PATH'];
        else if(isset($_SERVER['REDIRECT_L3_PATH']))
            $this->path = $_SERVER['REDIRECT_L3_PATH'];
        $this->method = $_SERVER['REQUEST_METHOD'];
        $this->accept = isset($_SERVER['HTTP_ACCEPT'])?$_SERVER['HTTP_ACCEPT']:"";
        $this->acceptTypes = $this->parseAccept($this->accept);
        $this->acceptLanguage = isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])?$_SERVER['HTTP_ACCEPT_LANGUAGE']:"";
        $this->userAgent = isset($_SERVER['HTTP_USER_AGENT'])?$_SERVER['HTTP_USER_AGENT']:null;
        if(function_exists('apache_request_headers')){
            $this->headers = apache_request_headers();
        }
        else{
            $this->headers = array();
            foreach($_SERVER as $key => $value) {
                if (substr($key, 0, 5) <> 'HTTP_') {
                    continue;
                }
                $header = str_replace(' ', '-', ucwords(str_replace('_', ' ', strtolower(substr($key, 5)))));
                $this->headers[$header] = $value;
            }
        }
        if (php_sapi_name() != "cli") {
            $this->body = file_get_contents('php://input');
        }
    }

    public function parseAccept($accept){
        //cut out the spaces
        $accept = str_replace(" ", "", $accept);

        $result = array();
        $quality_factors = array();

        // find content type and corresponding quality factor value
        foreach(explode(",", $accept) as $acceptParts){
            $type = explode(";", $acceptParts);
            $result[] = $type[0];
            if(count($type)>1){
                if(isset($type[1]) && $type[1][0].$type[1][1] == "q="){
                    $quality_factors[] = substr($type[1],2);
                }
                else if(isset($type[2]) && $type[2][0].$type[2][1] == "q="){
                    $quality_factors[] = substr($type[2],2);
                }
                else{
                    $quality_factors[] = 1;
                }
            }
            else{
                $quality_factors[] = 1;
            }
        }

        // sort the types according to quality factors
        array_multisort($quality_factors, SORT_DESC, SORT_NUMERIC, $result);

        return $result;
    }

}