<?php

namespace elanpl\L3;

class Serialization{
    protected static $serializers; //registered serializers dictionary

    public function __construct()
    {
        if(!isset(self::$serializers)) self::$serializers = array(); 
    }

    public static function register($contentType, $serializer, $viewModelClass = null){
        if(isset($viewModelClass) && $viewModelClass!=''){
            $class_key = $viewModelClass.'|';
        }
        else{
            $class_key = '';
        }
        self::$serializers[$class_key.$contentType] = $serializer;
    }

    public function match($acceptTypes, $viewModel=null){
        if(isset($viewModel)){
            if(is_object($viewModel)){
                $viewModelClass = get_class($viewModel);
            }
            if(is_string($viewModel)){
                $viewModelClass = $viewModel;
            }
        }

        if(is_array($acceptTypes)){
            $registeredTypes = array_keys(self::$serializers);

            foreach ($acceptTypes as $type){
                //Dedicated config for ViewModel class first...
                if(array_key_exists($viewModelClass."|".$type, self::$serializers)){
                    return $type;
                }
                foreach($registeredTypes as $rtype_with_class){
                    $rtype_parts = explode("|", $rtype_with_class);
                    if(count($rtype_parts)==2){
                        $rclass = $rtype_parts[0];
                        $t = explode("/", $type);
                        $rt = explode("/", $rtype_parts[1]);
                        if($rclass==$viewModelClass && ($t[0]=="*" || $rt[0]=="*" || $t[0]==$rt[0]) && ($t[1]=="*" || $rt[1]=="*" || $t[1]==$rt[1])){
                            return $rtype_with_class;
                        }
                    }
                }

                //Then check configs without the ViewModel class name
                if(array_key_exists($type, self::$serializers)){
                    return $type;
                }
                foreach($registeredTypes as $rtype){
                    $t = explode("/", $type);
                    $rt = explode("/", $rtype);
                    if(($t[0]=="*" || $rt[0]=="*" || $t[0]==$t[0]) && ($t[1]=="*" || $rt[1]=="*" || $t[1]==$t[1])){
                        return $rtype;
                    }
                }
            }
        }
        return false;
    }

    public function serialize($contentType, $viewModel){
        if(isset(Serialization::$serializers[get_class($viewModel).'|'.$contentType])){
            $serializerClass = Serialization::$serializers[get_class($viewModel).'|'.$contentType];
        }
        else if(isset(Serialization::$serializers[$contentType])){
            $serializerClass = Serialization::$serializers[$contentType];
        }

        if(isset($serializerClass)){
            $serializer = new $serializerClass();
            return $serializer->Serialize($viewModel);
        }
        else{
            return null;
        }
    }
}