<?php

namespace elanpl\L3;

class ViewEngine{
    protected $viewengines; //registered view engines dictionary

    public function __construct()
    {
        $this->viewengines = array(); 
    }

    public function register($fileExtension, $viewEngine){
        if(!class_exists($viewEngine,true)){
            throw new \Exception("Class \"$viewEngine\" not found!");
        }
        if(!isset(class_implements($viewEngine, true)['IViewEngine'])){
            throw new \Exception("Class \"$viewEngine\" does not implement IViewEngine interface!");
        }

        $this->viewengines[$fileExtension] = $viewEngine;
    }

    public function get($fileExtension){
        if(array_key_exists($fileExtension, $this->viewengines)){
            return $this->viewengines[$fileExtension];
        }
        else{
            return null;
        }
    }

    public function getRegisteredFileExtensions(){
        return array_keys($this->viewengines);
    }

}